<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Web extends CI_Controller
{

	public function index()
	{
		$data['web_ppdb']	 = $this->web->web_utama();
		$this->load->view('web/index', $data);
		if (isset($_POST['btnlogin'])) {
			$send = array(
				'username' => $this->input->post('username'),
				'password' => $this->input->post('password')
			);
			$auth = $this->web->auth('cek-masuk', $send);

			if ($auth['sum'] == 0) {
				$this->session->set_flashdata('msg', $this->err->wrong_auth());
				redirect('logcs');
			} else {
				$this->session->set_userdata('no_pendaftaran', $auth['res']->no_pendaftaran);
				redirect('calonsiswa');
			}
		}
	}

	public function idbaru($value = '')
	{
		echo $this->web->pendaftaran('id_baru');
	}

	public function pendaftaran()
	{
		$data = array(
			'id_daftar'			=> $this->web->pendaftaran('id_baru'),
			'web_ppdb'			=> $this->web->pendaftaran('status_ppdb'),
			'v_pdd'				=> $this->web->pendaftaran('v_pdd'),
			'v_penghasilan'		=> $this->web->pendaftaran('v_penghasilan'),
			'v_pekerjaan_ayah'	=> $this->web->pendaftaran('v_pekerjaan_ayah'),
			'v_komp'			=> $this->web->pendaftaran('v_komp'),
			'v_pekerjaan_ibu'	=> $this->web->pendaftaran('v_pekerjaan_ibu'),
			'v_pekerjaan_wali'	=> $this->web->pendaftaran('v_pekerjaan_wali')
		);

		if ($data['web_ppdb']->status_ppdb == 'tutup') {
			redirect('404');
		}

		$this->load->view('web/pendaftaran', $data);

		if (isset($_POST['btndaftar'])) {
			$acts = $this->web->pendaftaran('daftar', $this->input);

			$this->load->helper('string');
			$token =  sha1($acts['res']->no_pendaftaran);

			$this->load->library('ciqrcode');
			$config['cacheable']    = true; //boolean, the default is true
			$config['cachedir']     = './img/qrcode/cachedir/'; //string, the default is application/cache/
			$config['errorlog']     = './img/qrcode/errorlog/'; //string, the default is application/logs/
			$config['imagedir']     = './img/qrcode/imagedir/'; //direktori penyimpanan qr code
			$config['quality']      = true; //boolean, the default is true
			$config['size']         = '1024'; //interger, the default is 1024
			$config['black']        = array(224, 255, 255); // array, default is array(255,255,255)
			$config['white']        = array(70, 130, 180); // array, default is array(0,0,0)
			$this->ciqrcode->initialize($config);

			$image_name = $token . '.png'; //buat name dari qr code sesuai dengan nim
			// $params['data'] = site_url() . 'token_check/verify/' . $token; //data yang akan di jadikan QR CODE
			$params['data'] = $acts['res']->no_pendaftaran;
			$params['level'] = 'H'; //H=High
			$params['size'] = 10;
			$params['savename'] = $config['imagedir'] . $image_name; //simpan image QR CODE ke folder assets/images/
			$this->ciqrcode->generate($params); // fungsi untuk generate QR CODE

			$this->session->set_userdata('no_pendaftaran', $acts['res']->no_pendaftaran);
			redirect('calonsiswa');
		}
	}

	public function logcs()
	{
		$data['web_ppdb']	 = $this->web->pendaftaran('status_ppdb');
		if ($data['web_ppdb']->status_ppdb == 'tutup') {
			redirect('404');
		}

		if ($this->session->userdata('no_pendaftaran') != NULL) {
			redirect('calonsiswa');
		} else {
			$this->load->view('web/login/login', $data);

			if (isset($_POST['btnlogin'])) {
				$send = array(
					'username' => $this->input->post('username'),
					'password' => $this->input->post('password')
				);
				$auth = $this->web->auth('cek-masuk', $send);

				if ($auth['sum'] == 0) {
					$this->session->set_flashdata('msg', $this->err->wrong_auth());
					redirect('logcs');
				} else {
					$this->session->set_userdata('no_pendaftaran', $auth['res']->no_pendaftaran);
					redirect('calonsiswa');
				}
			}
		}
	}

	public function cari()
	{
		$data['siswa'] = $this->SiswaModel->view();
		$this->load->view('web/cari', $data);
	}

	function error_not_found()
	{
		$this->load->view('404_content');
	}
}
